/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities.storage;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.DataResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.util.BlockStateSerializationUtils;
import mod.chiselsandbits.api.util.INBTSerializable;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class SimpleStateEntryPalette
implements IPacketBufferSerializable,
INBTSerializable<class_2499> {
    private final List<Entry> paletteEntries = Collections.synchronizedList(Lists.newArrayList());
    private final BiMap<BlockInformation, Entry> paletteMap = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    private final IntConsumer onNewSizeAddedConsumer;

    public SimpleStateEntryPalette(IntConsumer onNewSizeAddedConsumer) {
        this.onNewSizeAddedConsumer = onNewSizeAddedConsumer;
        this.clear();
    }

    public SimpleStateEntryPalette(IntConsumer onPaletteResize, SimpleStateEntryPalette palette) {
        this.onNewSizeAddedConsumer = onPaletteResize;
        this.paletteEntries.addAll(palette.paletteEntries);
        this.paletteMap.putAll(palette.paletteMap);
    }

    @Override
    public class_2499 serializeNBT() {
        return this.paletteEntries.stream().map(INBTSerializable::serializeNBT).collect(Collectors.toCollection(class_2499::new));
    }

    @Override
    public void deserializeNBT(class_2499 nbt) {
        int currentSize = this.paletteEntries.size();
        this.paletteMap.clear();
        this.paletteEntries.clear();
        if (nbt.method_10601() == 8) {
            nbt.stream().filter(class_2519.class::isInstance).map(class_2519.class::cast).map(Entry::new).forEach(this.paletteEntries::add);
        } else if (nbt.method_10601() == 10) {
            nbt.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).map(Entry::new).forEach(this.paletteEntries::add);
        }
        this.paletteEntries.forEach(entry -> this.paletteMap.put((Object)entry.get(), entry));
        if (this.paletteEntries.size() == 0) {
            this.clear();
        }
        if (currentSize != this.paletteEntries.size()) {
            this.onNewSizeAddedConsumer.accept(this.paletteEntries.size());
        }
    }

    @Override
    public void serializeInto(@NotNull class_2540 packetBuffer) {
        packetBuffer.method_10804(this.paletteEntries.size());
        this.paletteEntries.forEach(entry -> entry.serializeInto(packetBuffer));
    }

    @Override
    public void deserializeFrom(@NotNull class_2540 packetBuffer) {
        int currentSize = this.paletteEntries.size();
        this.paletteEntries.clear();
        this.paletteMap.clear();
        int newCount = packetBuffer.method_10816();
        for (int i = 0; i < newCount; ++i) {
            this.paletteEntries.add(new Entry(packetBuffer));
        }
        this.paletteEntries.forEach(entry -> this.paletteMap.put((Object)entry.get(), entry));
        if (this.paletteEntries.size() == 0) {
            this.clear();
        }
        if (currentSize != this.paletteEntries.size()) {
            this.onNewSizeAddedConsumer.accept(this.paletteEntries.size());
        }
    }

    public int getIndex(BlockInformation state) {
        if (this.paletteMap.containsKey((Object)state)) {
            Entry entry = (Entry)this.paletteMap.get((Object)state);
            return this.paletteEntries.indexOf(entry);
        }
        Entry newEntry = new Entry(state);
        this.paletteMap.put((Object)state, (Object)newEntry);
        this.paletteEntries.add(newEntry);
        this.onNewSizeAddedConsumer.accept(this.paletteEntries.size());
        return this.paletteEntries.size() - 1;
    }

    public BlockInformation getBlockState(int blockStateId) {
        if (blockStateId < 0 || blockStateId >= this.paletteEntries.size()) {
            return this.getBlockState(0);
        }
        return this.paletteEntries.get(blockStateId).get();
    }

    public void sanitize(Collection<BlockInformation> toRemove) {
        List<Entry> toRemoveList = toRemove.stream().map(arg_0 -> this.paletteMap.get(arg_0)).toList();
        this.paletteEntries.removeAll(toRemoveList);
        toRemove.forEach(arg_0 -> this.paletteMap.remove(arg_0));
        this.onNewSizeAddedConsumer.accept(this.paletteEntries.size());
    }

    public void clear() {
        this.paletteEntries.clear();
        this.paletteMap.clear();
        this.getIndex(new BlockInformation(class_2246.field_10124.method_9564()));
    }

    public List<BlockInformation> getStates() {
        return this.paletteMap.keySet().stream().toList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleStateEntryPalette)) {
            return false;
        }
        SimpleStateEntryPalette that = (SimpleStateEntryPalette)o;
        return this.paletteEntries.equals(that.paletteEntries);
    }

    public int hashCode() {
        return this.paletteEntries.hashCode();
    }

    public String toString() {
        return "SimpleStateEntryPalette{paletteEntries=" + this.paletteEntries + "}";
    }

    private static final class Entry
    implements IPacketBufferSerializable,
    INBTSerializable<class_2487> {
        private BlockInformation outwardFacingState;
        private class_2487 rawSpec;

        private Entry(BlockInformation newState) {
            this.outwardFacingState = newState;
            this.rawSpec = newState.serializeNBT();
        }

        private Entry(class_2519 tag) {
            this.deserializeNBT(tag);
        }

        private Entry(class_2487 tag) {
            this.deserializeNBT(tag);
        }

        private Entry(class_2540 buffer) {
            this.deserializeFrom(buffer);
        }

        @Override
        public void deserializeNBT(class_2519 nbt) {
            String rawSpecString = nbt.method_10714();
            DataResult<class_2680> result = BlockStateSerializationUtils.deserialize(rawSpecString);
            this.outwardFacingState = new BlockInformation(result.result().orElseGet(() -> ((class_2248)class_2246.field_10124).method_9564()));
            this.rawSpec = this.outwardFacingState.serializeNBT();
        }

        @Override
        public class_2487 serializeNBT() {
            return this.rawSpec.method_10553();
        }

        @Override
        public void deserializeNBT(class_2487 nbt) {
            this.rawSpec = nbt;
            this.outwardFacingState = new BlockInformation(nbt);
        }

        @Override
        public void serializeInto(@NotNull class_2540 packetBuffer) {
            this.outwardFacingState.serializeInto(packetBuffer);
        }

        @Override
        public void deserializeFrom(@NotNull class_2540 packetBuffer) {
            this.outwardFacingState = new BlockInformation(packetBuffer);
            this.rawSpec = this.outwardFacingState.serializeNBT();
        }

        public BlockInformation get() {
            return this.outwardFacingState;
        }
    }
}

